/*
 * Decompiled with CFR 0.152.
 */
package com.bigstep.datalake;

import com.bigstep.datalake.DLFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;

public class KeytabUtil {
    public static void generateKeytab(String principalName, String userPassword, String keytabFile) throws IOException {
        if (userPassword.length() == 0) {
            throw new IllegalArgumentException("password must not have zero length");
        }
        if (!principalName.contains("@")) {
            throw new IllegalArgumentException("principal name must contain realm: principal@realm");
        }
        Keytab keytab = Keytab.getInstance();
        KerberosTime timeStamp = new KerberosTime();
        EnumSet<EncryptionType> ciphers = EnumSet.of(EncryptionType.AES256_CTS_HMAC_SHA1_96);
        Map keys = KerberosKeyFactory.getKerberosKeys((String)principalName, (String)userPassword, ciphers);
        KeytabEntry keytabEntry = new KeytabEntry(principalName, 1, timeStamp, 0, (EncryptionKey)keys.get(EncryptionType.AES256_CTS_HMAC_SHA1_96));
        List<KeytabEntry> entry = Arrays.asList(keytabEntry);
        keytab.setEntries(entry);
        keytab.write(new File(keytabFile));
    }

    public static void main(String[] argv) throws IllegalArgumentException, IOException {
        if (argv.length != 3) {
            System.err.println("Syntax: genkeytab <principal@realm> <keytab_file_path>");
            System.exit(-1);
        }
        if (!DLFileSystem.checkJCE()) {
            throw new IOException("Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files are not installed.");
        }
        String principalName = argv[1];
        String keytabFile = argv[2];
        System.out.print("Password (not checked for correctness against KDC):");
        String userPassword = String.valueOf(System.console().readPassword());
        KeytabUtil.generateKeytab(principalName, userPassword, keytabFile);
    }
}

